/*
 * Decompiled with CFR 0.152.
 */
package com.galois.ecc;

import com.galois.ecc.ECCProvider;
import com.galois.ecc.NISTCurveFactory;
import com.galois.ecc.PublicKey;
import com.galois.ecc.Signature;
import java.util.Random;

public final class ECC {
    public static void print(int[] x) {
        System.out.print("0x");
        for (int i = x.length - 1; i != -1; --i) {
            System.out.print(String.format("%8x ", x[i]));
        }
        System.out.println();
    }

    static void randomIntArray(Random r, int[] x) {
        for (int i = 0; i != x.length; ++i) {
            x[i] = r.nextInt();
        }
    }

    public static void main(String[] args) {
        ECCProvider ecc = NISTCurveFactory.createP384_64();
        int[] d = new int[]{-1755827072, -1508155427, 1506988305, 1333195862, -250501692, -1408946479, 1639295229, 272830887, 1619370572, -1817493918, -1503291340, -1528050971};
        int[] e = new int[]{1047869533, 721143433, -1792009704, -1416826544, -2135716479, -1124291039, 236113545, -1622431318, -1911338574, 2060178944, -1707444536, -1345353711};
        int[] k = new int[]{510905102, 1655780141, 1167960462, -341098137, 1756210197, -2049071065, -1665730269, -1370650138, -1036412959, -1279355108, 465380338, -73268296};
        Random r = new Random(42L);
        Signature sig = new Signature(12);
        PublicKey pubKey = new PublicKey(12);
        int totalRuns = 1000;
        long start = System.currentTimeMillis();
        for (int i = 0; i != totalRuns; ++i) {
            ECC.randomIntArray(r, d);
            ECC.randomIntArray(r, e);
            ECC.randomIntArray(r, k);
            ecc.initializePublicKey(pubKey, d);
            boolean b = ecc.signHash(sig, d, e, k);
            if (!b) {
                System.out.println("signHash failed (this has very low probability)");
                continue;
            }
            b = ecc.verifySignature(e, sig, pubKey);
            if (b) continue;
            System.out.println("verifySignature failed (this is a bug)");
            break;
        }
        long end = System.currentTimeMillis();
        System.out.println(String.format("Total time (%d sign/verify pairs): %dmsec", totalRuns, end - start));
    }
}

