/*
 * Decompiled with CFR 0.152.
 */
package com.galois.ecc;

import com.galois.ecc.AffinePoint;
import com.galois.ecc.JacobianPoint;
import com.galois.ecc.PublicKey;
import com.galois.ecc.Signature;
import com.galois.ecc.TwinMulAux2Rslt;

public abstract class ECCProvider {
    private final int width;
    protected final int[] field_prime;
    private final int[] field_unit;
    private final AffinePoint basePoint;
    private final AffinePoint basePoint3;
    private final AffinePoint basePoint5;
    protected final int[] group_order;
    private int[] h;
    private int[] t1;
    private int[] t2;
    private int[] t3;
    private int[] u1;
    private int[] u2;
    private JacobianPoint rP;
    private JacobianPoint sPtP;
    private JacobianPoint sMtP;
    private AffinePoint sPt;
    private AffinePoint sMt;
    private TwinMulAux2Rslt aux2Rslt;
    private final AffinePoint qPoint;

    protected ECCProvider(int width, int[] field_prime, int[] field_unit, int[] group_order, AffinePoint basePoint) {
        this.width = width;
        this.group_order = group_order;
        this.field_prime = field_prime;
        this.field_unit = field_unit;
        this.basePoint = basePoint;
        this.h = new int[width];
        this.t1 = new int[width];
        this.t2 = new int[width];
        this.t3 = new int[width];
        this.u1 = new int[width];
        this.u2 = new int[width];
        this.rP = new JacobianPoint(width);
        this.sPtP = new JacobianPoint(width);
        this.sMtP = new JacobianPoint(width);
        this.sPt = new AffinePoint(width);
        this.sMt = new AffinePoint(width);
        this.aux2Rslt = new TwinMulAux2Rslt();
        this.qPoint = new AffinePoint(width);
        this.basePoint3 = new AffinePoint(width);
        this.basePoint5 = new AffinePoint(width);
    }

    protected void init() {
        JacobianPoint s4 = new JacobianPoint(this.width);
        ECCProvider.ec_projectify(s4, this.basePoint);
        this.ec_double(s4);
        this.ec_double(s4);
        JacobianPoint s3J = new JacobianPoint(this.width);
        ECCProvider.copy_point(s3J, s4);
        this.ec_full_sub(s3J, this.basePoint);
        JacobianPoint s5J = new JacobianPoint(this.width);
        ECCProvider.copy_point(s5J, s4);
        this.ec_full_add(s5J, this.basePoint);
        this.ec_affinify(this.basePoint3, s3J);
        this.ec_affinify(this.basePoint5, s5J);
    }

    protected void cleanup() {
        ECCProvider.set_zero(this.h);
        ECCProvider.set_zero(this.t1);
        ECCProvider.set_zero(this.t2);
        ECCProvider.set_zero(this.t3);
        ECCProvider.set_zero(this.u1);
        ECCProvider.set_zero(this.u2);
        this.rP.clear();
        this.sPtP.clear();
        this.sMtP.clear();
        this.sPt.clear();
        this.sMt.clear();
        this.aux2Rslt.u0 = 0;
        this.aux2Rslt.u1 = 0;
        this.aux2Rslt.c0p = 0;
        this.aux2Rslt.c1p = 0;
        this.aux2Rslt.e0p = 0;
        this.aux2Rslt.e1p = 0;
        this.aux2Rslt.shp = 0;
        this.qPoint.clear();
    }

    private static boolean is_zero(int[] x) {
        for (int i = 0; i != x.length; ++i) {
            if (x[i] == 0) continue;
            return false;
        }
        return true;
    }

    private static boolean is_equal(int[] x, int[] y) {
        for (int i = 0; i != x.length; ++i) {
            if (x[i] == y[i]) continue;
            return false;
        }
        return true;
    }

    private static void assign(int[] x, int[] y) {
        for (int i = 0; i != x.length; ++i) {
            x[i] = y[i];
        }
    }

    static boolean leq(int[] x, int[] y) {
        int i = x.length;
        do {
            boolean yPos;
            if (x[--i] == y[i]) continue;
            boolean xPos = 0 <= x[i];
            boolean bl = yPos = 0 <= y[i];
            if (!yPos && xPos) {
                return true;
            }
            if (!xPos && yPos) {
                return false;
            }
            return x[i] < y[i];
        } while (i != 0);
        return true;
    }

    static void set_zero(int[] x) {
        for (int i = 0; i != x.length; ++i) {
            x[i] = 0;
        }
    }

    private static void set_unit(int[] x) {
        x[0] = 1;
        for (int i = 1; i != x.length; ++i) {
            x[i] = 0;
        }
    }

    private static void shr(int[] z, int c, int[] x) {
        for (int i = z.length - 1; i != -1; --i) {
            int xi = x[i];
            z[i] = c << 31 | xi >>> 1;
            c = xi & 1;
        }
    }

    public abstract void field_red(int[] var1, int[] var2);

    public abstract int field_red_aux(int[] var1, int[] var2);

    protected abstract int add(int[] var1, int[] var2, int[] var3);

    protected abstract int dbl(int[] var1, int[] var2);

    protected abstract int dbl_dec(int[] var1, int[] var2);

    protected abstract int sub(int[] var1, int[] var2, int[] var3);

    protected abstract int decFieldPrime(int[] var1);

    protected abstract int incFieldPrime(int[] var1);

    protected abstract void field_mul(int[] var1, int[] var2, int[] var3);

    protected abstract void field_sq(int[] var1, int[] var2);

    void field_mul_test(int[] z, int[] x, int[] y) {
        this.field_mul(z, x, y);
    }

    void field_sqr_test(int[] z, int[] x) {
        this.field_sq(z, x);
    }

    protected abstract void group_mul(int[] var1, int[] var2, int[] var3);

    public void field_add(int[] z, int[] x, int[] y) {
        if (this.add(z, x, y) != 0 || ECCProvider.leq(this.field_prime, z)) {
            this.decFieldPrime(z);
        }
    }

    private void field_dbl(int[] z, int[] x) {
        if (this.dbl(z, x) != 0 || ECCProvider.leq(this.field_prime, z)) {
            this.decFieldPrime(z);
        }
    }

    private void field_dbl_dec(int[] z, int[] x) {
        this.field_sub(z, z, x);
        this.field_sub(z, z, x);
    }

    public void field_mul3(int[] z, int[] x) {
        this.field_dbl(z, x);
        this.field_add(z, x, z);
    }

    private void field_mul4(int[] z, int[] x) {
        this.field_dbl(z, x);
        this.field_dbl(z, z);
    }

    private void field_mul8(int[] z, int[] x) {
        this.field_dbl(z, x);
        this.field_dbl(z, z);
        this.field_dbl(z, z);
    }

    private void field_normalize(int[] z) {
        if (ECCProvider.leq(this.field_prime, z)) {
            this.decFieldPrime(z);
        }
    }

    public void field_sub(int[] z, int[] x, int[] y) {
        int c = this.sub(z, x, y);
        if (c != 0) {
            this.incFieldPrime(z);
        }
    }

    private void group_add(int[] z, int[] x, int[] y) {
        int c = this.add(z, x, y);
        if (c != 0 || ECCProvider.leq(this.group_order, z)) {
            this.sub(z, z, this.group_order);
        }
    }

    private void mod_sub(int[] z, int[] x, int[] y, int[] p) {
        if (this.sub(z, x, y) != 0) {
            this.add(z, z, p);
        }
    }

    private void mod_half(int[] x, int[] p) {
        if ((x[0] & 1) != 0) {
            int c = this.add(x, x, p);
            ECCProvider.shr(x, c, x);
        } else {
            ECCProvider.shr(x, 0, x);
        }
    }

    private void mod_div(int[] ra, int[] x, int[] y, int[] p) {
        int[] a = this.t1;
        ECCProvider.assign(a, p);
        ECCProvider.set_zero(ra);
        int[] b = this.t2;
        ECCProvider.assign(b, y);
        int[] rb = this.t3;
        ECCProvider.assign(rb, x);
        boolean swapped = false;
        while (!ECCProvider.is_zero(b)) {
            if ((b[0] & 1) != 0) {
                if (!ECCProvider.leq(a, b)) {
                    int[] t = a;
                    a = b;
                    b = t;
                    t = ra;
                    ra = rb;
                    rb = t;
                    swapped = !swapped;
                }
                this.sub(b, b, a);
                this.mod_sub(rb, rb, ra, p);
            }
            ECCProvider.shr(b, 0, b);
            this.mod_half(rb, p);
        }
        if (swapped) {
            ECCProvider.assign(rb, ra);
        }
    }

    private void ec_affinify(AffinePoint r, JacobianPoint s) {
        this.mod_div(r.x, this.field_unit, s.z, this.field_prime);
        this.field_mul(r.y, s.y, r.x);
        this.field_sq(r.x, r.x);
        this.field_mul(r.y, r.y, r.x);
        this.field_mul(r.x, r.x, s.x);
    }

    private static void ec_projectify(JacobianPoint r, AffinePoint s) {
        ECCProvider.assign(r.x, s.x);
        ECCProvider.assign(r.y, s.y);
        ECCProvider.set_unit(r.z);
    }

    private void ec_double(JacobianPoint r) {
        int[] t4 = this.t1;
        int[] t5 = this.t2;
        if (ECCProvider.is_zero(r.z)) {
            ECCProvider.set_unit(r.x);
            ECCProvider.set_unit(r.y);
            ECCProvider.set_zero(r.z);
            return;
        }
        this.field_sq(t4, r.z);
        this.field_sub(t5, r.x, t4);
        this.field_add(t4, r.x, t4);
        this.field_mul(t5, t4, t5);
        this.field_mul3(t4, t5);
        this.field_mul(r.z, r.z, r.y);
        this.field_dbl(r.z, r.z);
        this.field_sq(r.y, r.y);
        this.field_mul(t5, r.x, r.y);
        this.field_mul4(t5, t5);
        this.field_sq(r.x, t4);
        this.field_dbl_dec(r.x, t5);
        this.field_sq(r.y, r.y);
        this.field_mul8(r.y, r.y);
        this.field_sub(t5, t5, r.x);
        this.field_mul(t5, t4, t5);
        this.field_sub(r.y, t5, r.y);
    }

    private void ec_full_add(JacobianPoint r, AffinePoint t) {
        int[] t4 = this.t1;
        int[] t5 = this.t2;
        int[] t7 = this.t3;
        if (ECCProvider.is_zero(r.z)) {
            ECCProvider.assign(r.x, t.x);
            ECCProvider.assign(r.y, t.y);
            ECCProvider.set_unit(r.z);
            return;
        }
        this.field_sq(t7, r.z);
        this.field_mul(t4, t.x, t7);
        this.field_mul(t7, r.z, t7);
        this.field_mul(t5, t.y, t7);
        this.field_sub(t4, r.x, t4);
        this.field_sub(t5, r.y, t5);
        if (ECCProvider.is_zero(t4)) {
            if (ECCProvider.is_zero(t5)) {
                this.ec_double(r);
            } else {
                ECCProvider.set_unit(r.x);
                ECCProvider.set_unit(r.y);
                ECCProvider.set_zero(r.z);
            }
        } else {
            this.field_dbl(r.x, r.x);
            this.field_sub(r.x, r.x, t4);
            this.field_dbl(r.y, r.y);
            this.field_sub(r.y, r.y, t5);
            this.field_mul(r.z, r.z, t4);
            this.field_sq(t7, t4);
            this.field_mul(t4, t4, t7);
            this.field_mul(t7, r.x, t7);
            this.field_sq(r.x, t5);
            this.field_sub(r.x, r.x, t7);
            this.field_dbl_dec(t7, r.x);
            this.field_mul(t5, t5, t7);
            this.field_mul(t4, r.y, t4);
            this.field_sub(r.y, t5, t4);
            this.mod_half(r.y, this.field_prime);
        }
    }

    private void ec_full_sub(JacobianPoint r, AffinePoint t) {
        boolean z = ECCProvider.is_zero(t.y);
        if (!z) {
            this.sub(t.y, this.field_prime, t.y);
        }
        this.ec_full_add(r, t);
        if (!z) {
            this.sub(t.y, this.field_prime, t.y);
        }
    }

    private static void copy_point(JacobianPoint r, JacobianPoint s) {
        ECCProvider.assign(r.x, s.x);
        ECCProvider.assign(r.y, s.y);
        ECCProvider.assign(r.z, s.z);
    }

    private void ec_mul(JacobianPoint r, int[] d, AffinePoint s) {
        this.ec_mul_init(r, d, s);
        for (int j = 32 * this.h.length - 1; j >= 0; --j) {
            int i = j >>> 5;
            boolean c = i < 11;
            this.ec_mul_aux(r, s, j, this.h[i], c, d[i], c ? d[i + 1] : 0);
        }
    }

    private void ec_mul_init(JacobianPoint r, int[] d, AffinePoint s) {
        ECCProvider.shr(this.h, 0, d);
        if (this.add(this.h, d, this.h) != 0) {
            ECCProvider.assign(r.x, s.x);
            ECCProvider.assign(r.y, s.y);
            ECCProvider.set_unit(r.z);
        } else {
            ECCProvider.set_unit(r.x);
            ECCProvider.set_unit(r.y);
            ECCProvider.set_zero(r.z);
        }
    }

    private void ec_mul_aux(JacobianPoint r, AffinePoint s, int j, int hi, boolean i_lt_11, int d_at_i, int d_at_ip1) {
        int m = 1 << j;
        int ki = d_at_i >>> 1;
        if (i_lt_11) {
            ki |= (d_at_ip1 & 1) << 31;
        }
        this.ec_double(r);
        if ((hi & m) != 0 && (ki & m) == 0) {
            this.ec_full_add(r, s);
        } else if ((hi & m) == 0 && (ki & m) != 0) {
            this.ec_full_sub(r, s);
        }
    }

    private void ec_mul_window_finish(JacobianPoint r, int j, int hi, int ki, AffinePoint s) {
        if (j == 1) {
            this.ec_double(r);
            if ((hi & 2) != 0 && (ki & 4) == 0) {
                this.ec_full_add(r, s);
                this.ec_double(r);
            } else if ((hi & 2) == 0 && (ki & 4) != 0) {
                this.ec_full_sub(r, s);
                this.ec_double(r);
            } else {
                this.ec_double(r);
                if ((hi & 1) != 0 && (ki & 2) == 0) {
                    this.ec_full_add(r, s);
                } else if ((hi & 1) == 0 && (ki & 2) != 0) {
                    this.ec_full_sub(r, s);
                }
            }
        } else if (j == 0) {
            this.ec_double(r);
            if ((hi & 1) != 0 && (ki & 2) == 0) {
                this.ec_full_add(r, s);
            } else if ((hi & 1) == 0 && (ki & 2) != 0) {
                this.ec_full_sub(r, s);
            }
        }
    }

    private int ec_mul_window_aux(JacobianPoint r, int j, int hi, int kai, int kip1, int hi2, int kai2, int ki2p1, AffinePoint s, AffinePoint s3, AffinePoint s5) {
        int ki = kai >>> 1 | (kip1 & 1) << 31;
        int m = 1 << j;
        this.ec_double(r);
        if ((hi & m) != 0 && (ki & m) == 0) {
            int ki2 = kai2 >>> 1 | (ki2p1 & 1) << 31;
            int m2 = 1 << (j -= 2);
            --j;
            if ((hi2 & m2) != 0 && (ki2 & m2) == 0) {
                this.ec_double(r);
                this.ec_double(r);
                this.ec_full_add(r, s5);
            } else if ((hi2 & m2) == 0 && (ki2 & m2) != 0) {
                this.ec_double(r);
                this.ec_double(r);
                this.ec_full_add(r, s3);
            } else {
                this.ec_full_add(r, s);
                this.ec_double(r);
                this.ec_double(r);
            }
        } else if ((hi & m) == 0 && (ki & m) != 0) {
            int ki2 = kai2 >>> 1 | (ki2p1 & 1) << 31;
            int m2 = 1 << (j -= 2);
            --j;
            if ((hi2 & m2) != 0 && (ki2 & m2) == 0) {
                this.ec_double(r);
                this.ec_double(r);
                this.ec_full_sub(r, s3);
            } else if ((hi2 & m2) == 0 && (ki2 & m2) != 0) {
                this.ec_double(r);
                this.ec_double(r);
                this.ec_full_sub(r, s5);
            } else {
                this.ec_full_sub(r, s);
                this.ec_double(r);
                this.ec_double(r);
            }
        } else {
            --j;
        }
        return j;
    }

    private void ec_mul_window(JacobianPoint r, int[] d, AffinePoint s, AffinePoint s3, AffinePoint s5) {
        int j;
        this.ec_mul_init(r, d, s);
        for (int c = j = 32 * this.h.length - 1; j >= 2 && c > 0; --c) {
            int i = j >>> 5;
            int i2 = j - 2 >>> 5;
            j = this.ec_mul_window_aux(r, j, this.h[i], d[i], i < 11 ? d[i + 1] : 0, this.h[i2], d[i2], i2 < 11 ? d[i2 + 1] : 0, s, s3, s5);
        }
        this.ec_mul_window_finish(r, j, this.h[0], d[0], s);
    }

    private static int ec_twin_mul_aux_f(int t) {
        if (18 <= t && t < 22) {
            return 9;
        }
        if (14 <= t && t < 18) {
            return 10;
        }
        if (22 <= t && t < 24) {
            return 11;
        }
        if (4 <= t && t < 12) {
            return 14;
        }
        return 12;
    }

    private void ec_twin_mul_aux2(int c0, int c1, int e0, int e1, int shift, int d0i, int d1i, boolean dv1, boolean dv2) {
        boolean h1Less;
        int h0 = c0 & 0x1F;
        if ((c0 & 0x20) != 0) {
            h0 = 31 - h0;
        }
        int h1 = c1 & 0x1F;
        if ((c1 & 0x20) != 0) {
            h1 = 31 - h1;
        }
        boolean h0Less = h0 < ECCProvider.ec_twin_mul_aux_f(h1);
        boolean bl = h1Less = h1 < ECCProvider.ec_twin_mul_aux_f(h0);
        int n = h0Less ? 0 : (this.aux2Rslt.u0 = (c0 & 0x20) != 0 ? -1 : 1);
        this.aux2Rslt.u1 = h1Less ? 0 : ((c1 & 0x20) != 0 ? -1 : 1);
        this.aux2Rslt.c0p = (h0Less ? 0 : 32) ^ c0 << 1 | e0 >>> shift & 1;
        this.aux2Rslt.c1p = (h1Less ? 0 : 32) ^ c1 << 1 | e1 >>> shift & 1;
        if (dv1) {
            if (dv2) {
                this.aux2Rslt.e0p = d0i;
                this.aux2Rslt.e1p = d1i;
                this.aux2Rslt.shp = 31;
            } else {
                this.aux2Rslt.e0p = 0;
                this.aux2Rslt.e1p = 0;
                this.aux2Rslt.shp = 31;
            }
        } else {
            this.aux2Rslt.e0p = e0;
            this.aux2Rslt.e1p = e1;
            this.aux2Rslt.shp = shift - 1;
        }
    }

    private boolean ec_twin_mul_init(JacobianPoint r, int[] d0, AffinePoint s, int[] d1, AffinePoint t, JacobianPoint sPtP, JacobianPoint sMtP, AffinePoint sPt, AffinePoint sMt) {
        if (ECCProvider.is_equal(s.x, t.x)) {
            int[] t0 = sPtP.x;
            if (ECCProvider.is_equal(s.y, t.y)) {
                this.group_add(t0, d0, d1);
                this.ec_mul(r, t0, s);
            } else {
                this.mod_sub(t0, d0, d1, this.group_order);
                this.ec_mul(r, t0, s);
            }
            ECCProvider.set_zero(sPt.x);
            ECCProvider.set_zero(sPt.y);
            ECCProvider.set_zero(sMt.x);
            ECCProvider.set_zero(sMt.y);
            return true;
        }
        ECCProvider.set_unit(r.x);
        ECCProvider.set_unit(r.y);
        ECCProvider.set_zero(r.z);
        ECCProvider.ec_projectify(sPtP, s);
        this.ec_full_add(sPtP, t);
        ECCProvider.ec_projectify(sMtP, s);
        this.ec_full_sub(sMtP, t);
        this.field_mul(sPt.y, sPtP.z, sMtP.z);
        this.mod_div(this.h, this.field_unit, sPt.y, this.field_prime);
        this.field_mul(sPt.x, sMtP.z, this.h);
        this.field_mul(sPt.y, sPtP.y, sPt.x);
        this.field_sq(sPt.x, sPt.x);
        this.field_mul(sPt.y, sPt.y, sPt.x);
        this.field_mul(sPt.x, sPtP.x, sPt.x);
        this.field_mul(sMt.x, sPtP.z, this.h);
        this.field_mul(sMt.y, sMtP.y, sMt.x);
        this.field_sq(sMt.x, sMt.x);
        this.field_mul(sMt.y, sMt.y, sMt.x);
        this.field_mul(sMt.x, sMtP.x, sMt.x);
        return false;
    }

    private void ec_twin_mul(JacobianPoint r, int[] d0, AffinePoint s, int[] d1, AffinePoint t, JacobianPoint sPtP, JacobianPoint sMtP, AffinePoint sPt, AffinePoint sMt) {
        if (this.ec_twin_mul_init(r, d0, s, d1, t, sPtP, sMtP, sPt, sMt)) {
            return;
        }
        int d0_11 = d0[11];
        int d1_11 = d1[11];
        int c0 = d0_11 >>> 28;
        int c1 = d1_11 >>> 28;
        int shift = 27;
        int e0 = d0_11;
        int e1 = d1_11;
        for (int k = 379; k != -6; --k) {
            int i = (k >>> 5) - 1;
            boolean dv1 = (k & 0x1F) == 0;
            boolean dv2 = i >= 0;
            int d0i = dv1 && dv2 ? d0[i] : 0;
            int d1i = dv1 && dv2 ? d1[i] : 0;
            this.ec_twin_mul_aux2(c0, c1, e0, e1, shift, d0i, d1i, dv1, dv2);
            int u0 = this.aux2Rslt.u0;
            int u1 = this.aux2Rslt.u1;
            c0 = this.aux2Rslt.c0p;
            c1 = this.aux2Rslt.c1p;
            this.ec_twin_mul_aux1(r, u0, u1, sPt, s, sMt, t);
            e0 = this.aux2Rslt.e0p;
            e1 = this.aux2Rslt.e1p;
            shift = this.aux2Rslt.shp;
        }
    }

    private void ec_twin_mul_aux1(JacobianPoint r, int u0, int u1, AffinePoint sPt, AffinePoint s, AffinePoint sMt, AffinePoint t) {
        this.ec_double(r);
        if (u0 == -1) {
            if (u1 == -1) {
                this.ec_full_sub(r, sPt);
            } else if (u1 == 0) {
                this.ec_full_sub(r, s);
            } else {
                this.ec_full_sub(r, sMt);
            }
        } else if (u0 == 0) {
            if (u1 == -1) {
                this.ec_full_sub(r, t);
            } else if (u1 == 1) {
                this.ec_full_add(r, t);
            }
        } else if (u1 == -1) {
            this.ec_full_add(r, sMt);
        } else if (u1 == 0) {
            this.ec_full_add(r, s);
        } else {
            this.ec_full_add(r, sPt);
        }
    }

    public boolean signHash(Signature signature, int[] privateKey, int[] hashValue, int[] ephemeralKey) {
        if (signature == null) {
            throw new NullPointerException("signature");
        }
        if (signature.r.length != this.width) {
            throw new IllegalArgumentException("Unexpected signature size.");
        }
        if (privateKey == null) {
            throw new NullPointerException("privateKey");
        }
        if (privateKey.length != this.width) {
            throw new IllegalArgumentException("Unexpected private key size.");
        }
        if (ECCProvider.is_zero(privateKey)) {
            throw new IllegalArgumentException("privateKey is zero.");
        }
        if (ECCProvider.leq(this.group_order, privateKey)) {
            throw new IllegalArgumentException("privateKey must be less than group order.");
        }
        if (hashValue == null) {
            throw new NullPointerException("hashValue");
        }
        if (hashValue.length != this.width) {
            throw new IllegalArgumentException("hashValue has incorrect size.");
        }
        if (ephemeralKey == null) {
            throw new NullPointerException("ephemeralKey");
        }
        if (ephemeralKey.length != this.width) {
            throw new IllegalArgumentException("Unexpected ephemeral key size.");
        }
        if (ECCProvider.is_zero(ephemeralKey)) {
            throw new IllegalArgumentException("ephemeralKey is zero.");
        }
        if (ECCProvider.leq(this.group_order, ephemeralKey)) {
            throw new IllegalArgumentException("ephemeralKey must be less than group order.");
        }
        ECCProvider.assign(this.u2, hashValue);
        if (ECCProvider.leq(this.group_order, this.u2)) {
            this.sub(this.u2, this.u2, this.group_order);
        }
        this.ec_mul(this.rP, ephemeralKey, this.basePoint);
        int[] r = signature.r;
        this.mod_div(r, this.field_unit, this.rP.z, this.field_prime);
        this.field_sq(r, r);
        this.field_mul(r, r, this.rP.x);
        if (ECCProvider.leq(this.group_order, r)) {
            this.sub(r, r, this.group_order);
        }
        if (ECCProvider.is_zero(signature.r)) {
            ECCProvider.set_zero(signature.s);
            this.cleanup();
            return false;
        }
        this.group_mul(this.h, privateKey, signature.r);
        this.group_add(this.h, this.u2, this.h);
        this.mod_div(signature.s, this.h, ephemeralKey, this.group_order);
        boolean failed = ECCProvider.is_zero(signature.s);
        if (failed) {
            ECCProvider.set_zero(signature.r);
        }
        this.cleanup();
        return !failed;
    }

    public PublicKey createPublicKey() {
        return new PublicKey(this.width);
    }

    public Signature createSignature() {
        return new Signature(this.width);
    }

    public void initializePublicKey(PublicKey publicKey, int[] privateKey) {
        if (publicKey == null) {
            throw new NullPointerException("publicKey");
        }
        if (publicKey.x.length != this.width) {
            throw new IllegalArgumentException("Unexpected public key size.");
        }
        if (privateKey == null) {
            throw new NullPointerException("privateKey");
        }
        if (privateKey.length != this.width) {
            throw new IllegalArgumentException("privateKey has incorrect size.");
        }
        if (ECCProvider.is_zero(privateKey)) {
            throw new IllegalArgumentException("privateKey is zero.");
        }
        if (ECCProvider.leq(this.group_order, privateKey)) {
            throw new IllegalArgumentException("privateKey must be less than group order.");
        }
        this.ec_mul(this.rP, privateKey, this.basePoint);
        this.mod_div(publicKey.x, this.field_unit, this.rP.z, this.field_prime);
        this.field_mul(publicKey.y, this.rP.y, publicKey.x);
        this.field_sq(publicKey.x, publicKey.x);
        this.field_mul(publicKey.y, publicKey.y, publicKey.x);
        this.field_mul(publicKey.x, publicKey.x, this.rP.x);
        this.cleanup();
    }

    public boolean verifySignature(int[] hashValue, Signature signature, PublicKey publicKey) {
        if (hashValue == null) {
            throw new NullPointerException("hashValue");
        }
        if (hashValue.length != this.width) {
            throw new IllegalArgumentException("hashValue has incorrect size.");
        }
        if (signature == null) {
            throw new NullPointerException("signature");
        }
        if (signature.r.length != this.width) {
            throw new IllegalArgumentException("Unexpected signature size.");
        }
        if (publicKey == null) {
            throw new NullPointerException("publicKey");
        }
        if (publicKey.x.length != this.width) {
            throw new IllegalArgumentException("Unexpected public key size.");
        }
        if (ECCProvider.is_zero(signature.r) || ECCProvider.leq(this.group_order, signature.r)) {
            this.cleanup();
            return false;
        }
        if (ECCProvider.is_zero(signature.s) || ECCProvider.leq(this.group_order, signature.s)) {
            this.cleanup();
            return false;
        }
        ECCProvider.assign(this.u2, hashValue);
        if (ECCProvider.leq(this.group_order, this.u2)) {
            this.sub(this.u2, this.u2, this.group_order);
        }
        this.mod_div(this.h, this.field_unit, signature.s, this.group_order);
        this.group_mul(this.u1, this.u2, this.h);
        this.group_mul(this.u2, signature.r, this.h);
        ECCProvider.assign(this.qPoint.x, publicKey.x);
        ECCProvider.assign(this.qPoint.y, publicKey.y);
        this.ec_twin_mul(this.rP, this.u1, this.basePoint, this.u2, this.qPoint, this.sPtP, this.sMtP, this.sPt, this.sMt);
        if (ECCProvider.is_zero(this.rP.z)) {
            this.cleanup();
            return false;
        }
        this.field_sq(this.rP.z, this.rP.z);
        this.field_mul(this.t1, signature.r, this.rP.z);
        if (ECCProvider.is_equal(this.t1, this.rP.x)) {
            this.cleanup();
            return true;
        }
        if (this.add(this.h, signature.r, this.group_order) == 0) {
            this.field_mul(this.t1, this.h, this.rP.z);
            if (ECCProvider.is_equal(this.t1, this.rP.x)) {
                this.cleanup();
                return true;
            }
        }
        this.cleanup();
        return false;
    }
}

