/*
 * Decompiled with CFR 0.152.
 */
package com.galois.ecc;

import com.galois.ecc.AffinePoint;
import com.galois.ecc.ECCProvider;

abstract class NIST32
extends ECCProvider {
    private int[] a;
    private int[] r;
    protected int[] neg_group_order;
    static final int INT_MASK = 65535;

    @Override
    public int field_red_aux(int[] z, int[] a) {
        System.out.println("field_red_aux not implemented for NIST32");
        return 0;
    }

    NIST32(int width, int[] field_prime, int[] field_unit, int[] group_order, int[] neg_group_order, AffinePoint basePoint) {
        super(width, field_prime, field_unit, group_order, basePoint);
        this.neg_group_order = neg_group_order;
        this.a = new int[width << 1];
        this.r = new int[width];
    }

    @Override
    protected void cleanup() {
        NIST32.set_zero(this.a);
        super.cleanup();
    }

    @Override
    protected int add(int[] z, int[] x, int[] y) {
        int w = z.length;
        int c = 0;
        for (int i = 0; i != w; ++i) {
            int v = ((c += (x[i] & 0xFFFF) + (y[i] & 0xFFFF)) >> 16) + (x[i] >>> 16) + (y[i] >>> 16);
            z[i] = c & 0xFFFF | v << 16;
            c = v >> 16;
        }
        return c;
    }

    @Override
    protected int dbl(int[] z, int[] x) {
        int w = z.length;
        int c = 0;
        for (int i = 0; i != w; ++i) {
            int v = ((c += (x[i] & 0xFFFF) << 1) >> 16) + (x[i] >>> 16 << 1);
            z[i] = c & 0xFFFF | v << 16;
            c = v >> 16;
        }
        return c;
    }

    @Override
    protected int dbl_dec(int[] z, int[] x) {
        int w = z.length;
        int c = 0;
        for (int i = 0; i != w; ++i) {
            int v = ((c += (z[i] & 0xFFFF) - ((x[i] & 0xFFFF) << 1)) >> 16) + (z[i] >>> 16) - (x[i] >>> 16 << 1);
            z[i] = c & 0xFFFF | v << 16;
            c = v >> 16;
        }
        return c;
    }

    private int iadd(int[] z, int zi, int[] x, int xi, int[] y, int yi, int w) {
        int c = 0;
        for (int i = w; i != 0; --i) {
            int v = ((c += (x[xi] & 0xFFFF) + (y[yi] & 0xFFFF)) >> 16) + (x[xi] >>> 16) + (y[yi] >>> 16);
            z[zi] = c & 0xFFFF | v << 16;
            c = v >> 16;
            ++xi;
            ++yi;
            ++zi;
        }
        return c;
    }

    private int idec(int[] z, int zi, int[] x, int xi, int xw) {
        int c = 0;
        for (int i = xw; i != 0; --i) {
            int v = ((c += (z[zi] & 0xFFFF) - (x[xi] & 0xFFFF)) >> 16) + (z[zi] >>> 16) - (x[xi] >>> 16);
            z[zi] = c & 0xFFFF | v << 16;
            c = v >> 16;
            ++zi;
            ++xi;
        }
        return c;
    }

    private int iinc(int[] z, int zi, int[] x, int xi, int w) {
        int c = 0;
        for (int i = w; i != 0; --i) {
            int v = ((c += (z[zi] & 0xFFFF) + (x[xi] & 0xFFFF)) >> 16) + (z[zi] >>> 16) + (x[xi] >>> 16);
            z[zi] = c & 0xFFFF | v << 16;
            c = v >> 16;
            ++zi;
            ++xi;
        }
        return c;
    }

    private int iincc(int[] z, int zi, int zw, int c) {
        for (int i = zw; i != 0 && c != 0; --i) {
            int v = ((c += z[zi] & 0xFFFF) >> 16) + (z[zi] >>> 16);
            z[zi] = c & 0xFFFF | v << 16;
            c = v >> 16;
            ++zi;
        }
        return c;
    }

    private void imul(int[] a, int ai, int[] x, int xi, int[] y, int yi, int w) {
        int aw = ai + w;
        int yw = yi + w;
        for (int j = ai; j != aw; ++j) {
            a[j] = 0;
        }
        for (int i = 0; i != w; ++i) {
            int xil = x[xi] & 0xFFFF;
            int xih = x[xi] >>> 16;
            ++xi;
            int ij = ai++;
            int c = 0;
            int j = yi;
            while (j != yw) {
                int yjl = y[j] & 0xFFFF;
                int yjh = y[j] >>> 16;
                int mll = xil * yjl;
                int mlh = xil * yjh;
                int mhl = xih * yjl;
                int mhh = xih * yjh;
                int vl = (a[ij] & 0xFFFF) + (c & 0xFFFF) + mll;
                int vh = (a[ij] >>> 16) + (vl >>> 16) + (c >>> 16) + (mlh & 0xFFFF) + (mhl & 0xFFFF);
                a[ij] = vl & 0xFFFF | vh << 16;
                c = (vh >>> 16) + (mlh >>> 16) + (mhl >>> 16) + mhh;
                ++j;
                ++ij;
            }
            a[ij] = c;
        }
    }

    private void kmul(int[] a, int[] x, int[] y) {
        int i;
        int w = x.length;
        int l = w >> 1;
        int c0 = this.iadd(this.r, 0, x, 0, x, l, l);
        int c1 = this.iadd(this.r, l, y, 0, y, l, l);
        for (i = 0; i != l; ++i) {
            a[i] = 0;
        }
        this.imul(a, l, this.r, 0, this.r, l, l);
        for (i = w + l; i != w << 1; ++i) {
            a[i] = 0;
        }
        if (c1 != 0) {
            int n = w + l;
            a[n] = a[n] + this.iinc(a, w, this.r, 0, l);
        }
        if (c0 != 0) {
            int n = w + l;
            a[n] = a[n] + this.iinc(a, w, this.r, l, l);
        }
        if ((c0 & c1) != 0) {
            int n = w + l;
            a[n] = a[n] + 1;
        }
        this.imul(this.r, 0, x, 0, y, 0, l);
        int c = this.iinc(a, 0, this.r, 0, w);
        int n = w + l;
        a[n] = a[n] + this.iincc(a, w, l, c);
        int n2 = w + l;
        a[n2] = a[n2] + this.idec(a, l, this.r, 0, w);
        this.imul(this.r, 0, x, l, y, l, l);
        int n3 = w + l;
        a[n3] = a[n3] + this.idec(a, l, this.r, 0, w);
        this.iinc(a, w, this.r, 0, w);
    }

    protected void sq(int[] a, int[] x) {
        int c;
        int xih;
        int xil;
        int i;
        int w = x.length;
        for (int j = 0; j != w; ++j) {
            a[j] = 0;
        }
        for (i = 0; i != w - 1; ++i) {
            xil = x[i] & 0xFFFF;
            xih = x[i] >>> 16;
            c = 0;
            int ij = (i << 1) + 1;
            int j = i + 1;
            while (j != w) {
                int xjl = x[j] & 0xFFFF;
                int xjh = x[j] >>> 16;
                int mll = xil * xjl;
                int mlh = xil * xjh;
                int mhl = xih * xjl;
                int mhh = xih * xjh;
                int vl = (a[ij] & 0xFFFF) + (c & 0xFFFF) + mll;
                int vh = (a[ij] >>> 16) + (vl >>> 16) + (c >>> 16) + (mlh & 0xFFFF) + (mhl & 0xFFFF);
                a[ij] = vl & 0xFFFF | vh << 16;
                c = (vh >>> 16) + (mlh >>> 16) + (mhl >>> 16) + mhh;
                ++j;
                ++ij;
            }
            a[ij] = c;
        }
        a[23] = 0;
        c = 0;
        for (i = 0; i != w; ++i) {
            xil = x[i] & 0xFFFF;
            xih = x[i] >>> 16;
            int mll = xil * xil;
            int mlh = xil * xih;
            int mhh = xih * xih;
            int ij = i << 1;
            int vl = ((a[ij] & 0xFFFF) << 1) + (c & 0xFFFF) + (mll & 0xFFFF);
            int vh = ((a[ij] >>> 16) + (mlh & 0xFFFF) << 1) + (vl >>> 16) + (c >>> 16) + (mll >>> 16);
            a[ij] = vl & 0xFFFF | vh << 16;
            vl = ((a[++ij] & 0xFFFF) + (mlh >>> 16) << 1) + (vh >>> 16) + (mhh & 0xFFFF);
            vh = (a[ij] >>> 16 << 1) + (vl >>> 16) + (mhh >>> 16);
            a[ij] = vl & 0xFFFF | vh << 16;
            c = vh >>> 16;
            ++ij;
        }
    }

    @Override
    protected int sub(int[] z, int[] x, int[] y) {
        int c = 0;
        for (int i = 0; i < z.length; ++i) {
            int vl = c + (x[i] & 0xFFFF) - (y[i] & 0xFFFF);
            int vh = (vl >> 16) + (x[i] >>> 16) - (y[i] >>> 16);
            z[i] = vl & 0xFFFF | vh << 16;
            c = vh >> 16;
        }
        return c;
    }

    @Override
    protected void field_mul(int[] z, int[] x, int[] y) {
        this.imul(this.a, 0, x, 0, y, 0, x.length);
        this.field_red(z, this.a);
    }

    @Override
    protected void field_sq(int[] z, int[] x) {
        this.sq(this.a, x);
        this.field_red(z, this.a);
    }

    private void group_red(int[] r, int x) {
        int xl = x & 0xFFFF;
        int xh = x >>> 16;
        int c = 0;
        for (int j = 0; j != r.length; ++j) {
            int gjl = this.neg_group_order[j] & 0xFFFF;
            int gjh = this.neg_group_order[j] >>> 16;
            int mll = xl * gjl;
            int mlh = xl * gjh;
            int mhl = xh * gjl;
            int mhh = xh * gjh;
            int vl = (r[j] & 0xFFFF) + (c & 0xFFFF) + mll;
            int vh = (r[j] >>> 16) + (vl >>> 16) + (c >>> 16) + (mlh & 0xFFFF) + (mhl & 0xFFFF);
            r[j] = vl & 0xFFFF | vh << 16;
            c = (vh >>> 16) + (mlh >>> 16) + (mhl >>> 16) + mhh;
        }
        while (c != 0) {
            c -= this.sub(r, r, this.group_order);
        }
    }

    @Override
    protected void group_mul(int[] r, int[] x, int[] y) {
        int w = x.length;
        NIST32.set_zero(r);
        for (int i = w - 1; i != -1; --i) {
            int xil = x[i] & 0xFFFF;
            int xih = x[i] >>> 16;
            int rmax = r[w - 1];
            for (int j = w - 1; j != 0; --j) {
                r[j] = r[j - 1];
            }
            r[0] = 0;
            this.group_red(r, rmax);
            int c = 0;
            for (int j = 0; j != w; ++j) {
                int yjl = y[j] & 0xFFFF;
                int yjh = y[j] >>> 16;
                int mll = xil * yjl;
                int mlh = xil * yjh;
                int mhl = xih * yjl;
                int mhh = xih * yjh;
                int vl = (r[j] & 0xFFFF) + (c & 0xFFFF) + mll;
                int vh = (r[j] >>> 16) + (vl >>> 16) + (c >>> 16) + (mlh & 0xFFFF) + (mhl & 0xFFFF);
                r[j] = vl & 0xFFFF | vh << 16;
                c = (vh >>> 16) + (mlh >>> 16) + (mhl >>> 16) + mhh;
            }
            this.group_red(r, c);
        }
        if (NIST32.leq(this.group_order, r)) {
            this.add(r, r, this.neg_group_order);
        }
    }
}

