/*
 * Decompiled with CFR 0.152.
 */
package com.galois.ecc;

import com.galois.ecc.AffinePoint;
import com.galois.ecc.ECCProvider;

abstract class NIST64
extends ECCProvider {
    private int[] a;
    static final long LONG_MASK = 0xFFFFFFFFL;

    NIST64(int width, int[] field_prime, int[] field_unit, int[] group_order, AffinePoint basePoint) {
        super(width, field_prime, field_unit, group_order, basePoint);
        this.a = new int[width << 1];
    }

    @Override
    protected void cleanup() {
        NIST64.set_zero(this.a);
        super.cleanup();
    }

    @Override
    protected int add(int[] z, int[] x, int[] y) {
        long c = 0L;
        for (int i = 0; i != z.length; ++i) {
            z[i] = (int)(c += ((long)x[i] & 0xFFFFFFFFL) + ((long)y[i] & 0xFFFFFFFFL));
            c >>= 32;
        }
        return (int)c;
    }

    @Override
    protected int dbl(int[] z, int[] x) {
        long c = 0L;
        for (int i = 0; i != z.length; ++i) {
            z[i] = (int)(c += ((long)x[i] & 0xFFFFFFFFL) << 1);
            c >>= 32;
        }
        return (int)c;
    }

    @Override
    protected int dbl_dec(int[] z, int[] y) {
        long b = 0L;
        for (int i = 0; i != z.length; ++i) {
            z[i] = (int)(b += ((long)z[i] & 0xFFFFFFFFL) - (((long)y[i] & 0xFFFFFFFFL) << 1));
            b >>= 32;
        }
        return (int)b;
    }

    private long mul_inner(boolean azero, int[] a, int ij, int xi, int yj, long d) {
        long m = ((long)xi & 0xFFFFFFFFL) * ((long)yj & 0xFFFFFFFFL);
        long aij = azero ? 0L : (long)a[ij] & 0xFFFFFFFFL;
        d = d + m + aij;
        a[ij] = (int)d;
        return d >>> 32;
    }

    protected void mul(int[] a, int[] x, int[] y) {
        int l = x.length;
        long d = 0L;
        for (int j = 0; j != l; ++j) {
            d = this.mul_inner(true, a, j, x[0], y[j], d);
        }
        a[l] = (int)d;
        for (int i = 1; i != l; ++i) {
            d = 0L;
            int ij = i;
            int j = 0;
            while (j != l) {
                d = this.mul_inner(false, a, ij, x[i], y[j], d);
                ++j;
                ++ij;
            }
            a[ij] = (int)d;
        }
    }

    private long sq_inner1(int[] a, int ij, long c) {
        a[ij] = (int)(c += ((long)a[ij] & 0xFFFFFFFFL) << 1);
        return c >>>= 32;
    }

    private long sq_inner2(int[] a, int ij, int xati, long c) {
        long xi = (long)xati & 0xFFFFFFFFL;
        long m = xi * xi;
        a[ij] = (int)(c += (m & 0xFFFFFFFFL) + (((long)a[ij] & 0xFFFFFFFFL) << 1));
        c = (c >>> 32) + (m >>> 32);
        return c;
    }

    private void sq_loop(int[] a, int[] x) {
        int l = x.length;
        for (int i = 1; i != l - 1; ++i) {
            long c = 0L;
            int ij = i + i + 1;
            int j = i + 1;
            while (j != l) {
                c = this.mul_inner(false, a, ij, x[i], x[j], c);
                ++j;
                ++ij;
            }
            a[ij] = (int)c;
        }
    }

    protected void sq(int[] a, int[] x) {
        int l = x.length;
        long c = 0L;
        for (int j = 1; j != l; ++j) {
            c = this.mul_inner(true, a, j, x[0], x[j], c);
        }
        a[l] = (int)c;
        this.sq_loop(a, x);
        c = this.mul_inner(true, a, 0, x[0], x[0], 0L);
        int ij = 1;
        for (int i = 1; i != l; ++i) {
            c = this.sq_inner1(a, ij, c);
            c = this.sq_inner2(a, ++ij, x[i], c);
            ++ij;
        }
        a[(l << 1) - 1] = (int)c;
    }

    @Override
    protected int sub(int[] z, int[] x, int[] y) {
        long b = 0L;
        for (int i = 0; i < z.length; ++i) {
            z[i] = (int)(b += ((long)x[i] & 0xFFFFFFFFL) - ((long)y[i] & 0xFFFFFFFFL));
            b >>= 32;
        }
        return (int)b;
    }

    @Override
    protected void field_mul(int[] z, int[] x, int[] y) {
        this.mul(this.a, x, y);
        this.field_red(z, this.a);
    }

    @Override
    protected void field_sq(int[] z, int[] x) {
        this.sq(this.a, x);
        this.field_red(z, this.a);
    }

    private long group_red_aux(int[] r, int aj, int j, long c, long b) {
        long m = c * ((long)aj & 0xFFFFFFFFL);
        r[j] = (int)(b += ((long)r[j] & 0xFFFFFFFFL) - (m & 0xFFFFFFFFL));
        b = (b >> 32) - (m >>> 32);
        return b;
    }

    private void group_red(int[] r, long c) {
        long b = 0L;
        for (int j = 0; j != r.length; ++j) {
            b = this.group_red_aux(r, this.group_order[j], j, c, b);
        }
        if ((c += b) != 0L) {
            c += (long)this.sub(r, r, this.group_order);
        }
        if (c != 0L) {
            c += (long)this.sub(r, r, this.group_order);
        }
    }

    private long array_shift(int[] r) {
        int l = r.length;
        long c = (long)r[l - 1] & 0xFFFFFFFFL;
        for (int j = l - 1; j != 0; --j) {
            r[j] = r[j - 1];
        }
        r[0] = 0;
        return c;
    }

    private long group_mul_aux(int[] r, int yj, int j, int xi, long c) {
        long m = ((long)xi & 0xFFFFFFFFL) * ((long)yj & 0xFFFFFFFFL);
        r[j] = (int)(c += ((long)r[j] & 0xFFFFFFFFL) + (m & 0xFFFFFFFFL));
        c = (c >>> 32) + (m >>> 32);
        return c;
    }

    @Override
    protected void group_mul(int[] r, int[] x, int[] y) {
        int l = x.length;
        NIST64.set_zero(r);
        for (int i = l - 1; i != -1; --i) {
            this.group_red(r, this.array_shift(r));
            long c = 0L;
            for (int j = 0; j != l; ++j) {
                c = this.group_mul_aux(r, y[j], j, x[i], c);
            }
            this.group_red(r, c);
        }
        if (NIST64.leq(this.group_order, r)) {
            this.sub(r, r, this.group_order);
        }
    }
}

