/*
 * Decompiled with CFR 0.152.
 */
package com.galois.ecc;

import com.galois.ecc.NIST32;
import com.galois.ecc.P384Constants;

class P384ECC32
extends NIST32 {
    static final int INT_MASK = 65535;

    P384ECC32() {
        super(12, P384Constants.field_prime, P384Constants.unit_vector, P384Constants.group_order, P384Constants.neg_group_order, P384Constants.basePoint);
        this.init();
    }

    @Override
    protected int decFieldPrime(int[] x) {
        int v = x[0];
        int c = (v & 0xFFFF) + 1;
        v = (c >> 16) + (v >>> 16);
        x[0] = c & 0xFFFF | v << 16;
        c = v >> 16;
        v = x[1];
        c += (v & 0xFFFF) + 65535;
        v = (c >> 16) + (v >>> 16) + 65535;
        x[1] = c & 0xFFFF | v << 16;
        c = v >> 16;
        v = x[2];
        c += (v & 0xFFFF) + 65535;
        v = (c >> 16) + (v >>> 16) + 65535;
        x[2] = c & 0xFFFF | v << 16;
        c = v >> 16;
        v = x[3];
        c += v & 0xFFFF;
        v = (c >> 16) + (v >>> 16);
        x[3] = c & 0xFFFF | v << 16;
        c = v >> 16;
        v = x[4];
        c += (v & 0xFFFF) + 1;
        v = (c >> 16) + (v >>> 16);
        x[4] = c & 0xFFFF | v << 16;
        c = v >> 16;
        for (int i = 5; i != 12; ++i) {
            v = x[i];
            c += v & 0xFFFF;
            v = (c >> 16) + (v >>> 16);
            x[i] = c & 0xFFFF | v << 16;
            c = v >> 16;
        }
        return c - 1;
    }

    @Override
    protected int incFieldPrime(int[] x) {
        int v = x[0];
        int c = (v & 0xFFFF) - 1;
        v = (c >> 16) + (v >>> 16);
        x[0] = c & 0xFFFF | v << 16;
        c = v >> 16;
        v = x[1];
        c += (v & 0xFFFF) - 65535;
        v = (c >> 16) + (v >>> 16) - 65535;
        x[1] = c & 0xFFFF | v << 16;
        c = v >> 16;
        v = x[2];
        c += (v & 0xFFFF) - 65535;
        v = (c >> 16) + (v >>> 16) - 65535;
        x[2] = c & 0xFFFF | v << 16;
        c = v >> 16;
        v = x[3];
        c += v & 0xFFFF;
        v = (c >> 16) + (v >>> 16);
        x[3] = c & 0xFFFF | v << 16;
        c = v >> 16;
        v = x[4];
        c += (v & 0xFFFF) - 1;
        v = (c >> 16) + (v >>> 16);
        x[4] = c & 0xFFFF | v << 16;
        c = v >> 16;
        for (int i = 5; i != 12; ++i) {
            v = x[i];
            c += v & 0xFFFF;
            v = (c >> 16) + (v >>> 16);
            x[i] = c & 0xFFFF | v << 16;
            c = v >> 16;
        }
        return c + 1;
    }

    @Override
    public void field_red(int[] z, int[] a) {
        int a12l = a[12] & 0xFFFF;
        int a12h = a[12] >>> 16;
        int a13l = a[13] & 0xFFFF;
        int a13h = a[13] >>> 16;
        int a14l = a[14] & 0xFFFF;
        int a14h = a[14] >>> 16;
        int a15l = a[15] & 0xFFFF;
        int a15h = a[15] >>> 16;
        int a16l = a[16] & 0xFFFF;
        int a16h = a[16] >>> 16;
        int a17l = a[17] & 0xFFFF;
        int a17h = a[17] >>> 16;
        int a18l = a[18] & 0xFFFF;
        int a18h = a[18] >>> 16;
        int a19l = a[19] & 0xFFFF;
        int a19h = a[19] >>> 16;
        int a20l = a[20] & 0xFFFF;
        int a20h = a[20] >>> 16;
        int a21l = a[21] & 0xFFFF;
        int a21h = a[21] >>> 16;
        int a22l = a[22] & 0xFFFF;
        int a22h = a[22] >>> 16;
        int a23l = a[23] & 0xFFFF;
        int a23h = a[23] >>> 16;
        int c = (a[0] & 0xFFFF) + a12l + a21l + a20l - a23l;
        int v = (c >> 16) + (a[0] >>> 16) + a12h + a21h + a20h - a23h;
        z[0] = c & 0xFFFF | v << 16;
        c = v >> 16;
        v = ((c += (a[1] & 0xFFFF) + a13l + a22l + a23l - a12l - a20l) >> 16) + (a[1] >>> 16) + a13h + a22h + a23h - a12h - a20h;
        z[1] = c & 0xFFFF | v << 16;
        c = v >> 16;
        v = ((c += (a[2] & 0xFFFF) + a14l + a23l - a13l - a21l) >> 16) + (a[2] >>> 16) + a14h + a23h - a13h - a21h;
        z[2] = c & 0xFFFF | v << 16;
        c = v >> 16;
        v = ((c += (a[3] & 0xFFFF) + a15l + a12l + a20l + a21l - a14l - a22l - a23l) >> 16) + (a[3] >>> 16) + a15h + a12h + a20h + a21h - a14h - a22h - a23h;
        z[3] = c & 0xFFFF | v << 16;
        c = v >> 16;
        v = ((c += (a[4] & 0xFFFF) + (a21l << 1) + a16l + a13l + a12l + a20l + a22l - a15l - (a23l << 1)) >> 16) + (a[4] >>> 16) + (a21h << 1) + a16h + a13h + a12h + a20h + a22h - a15h - (a23h << 1);
        z[4] = c & 0xFFFF | v << 16;
        c = v >> 16;
        v = ((c += (a[5] & 0xFFFF) + (a22l << 1) + a17l + a14l + a13l + a21l + a23l - a16l) >> 16) + (a[5] >>> 16) + (a22h << 1) + a17h + a14h + a13h + a21h + a23h - a16h;
        z[5] = c & 0xFFFF | v << 16;
        c = v >> 16;
        v = ((c += (a[6] & 0xFFFF) + (a23l << 1) + a18l + a15l + a14l + a22l - a17l) >> 16) + (a[6] >>> 16) + (a23h << 1) + a18h + a15h + a14h + a22h - a17h;
        z[6] = c & 0xFFFF | v << 16;
        c = v >> 16;
        v = ((c += (a[7] & 0xFFFF) + a19l + a16l + a15l + a23l - a18l) >> 16) + (a[7] >>> 16) + a19h + a16h + a15h + a23h - a18h;
        z[7] = c & 0xFFFF | v << 16;
        c = v >> 16;
        v = ((c += (a[8] & 0xFFFF) + a20l + a17l + a16l - a19l) >> 16) + (a[8] >>> 16) + a20h + a17h + a16h - a19h;
        z[8] = c & 0xFFFF | v << 16;
        c = v >> 16;
        v = ((c += (a[9] & 0xFFFF) + a21l + a18l + a17l - a20l) >> 16) + (a[9] >>> 16) + a21h + a18h + a17h - a20h;
        z[9] = c & 0xFFFF | v << 16;
        c = v >> 16;
        v = ((c += (a[10] & 0xFFFF) + a22l + a19l + a18l - a21l) >> 16) + (a[10] >>> 16) + a22h + a19h + a18h - a21h;
        z[10] = c & 0xFFFF | v << 16;
        c = v >> 16;
        v = ((c += (a[11] & 0xFFFF) + a23l + a20l + a19l - a22l) >> 16) + (a[11] >>> 16) + a23h + a20h + a19h - a22h;
        z[11] = c & 0xFFFF | v << 16;
        c = v >> 16;
        if (c > 0) {
            int ofl = c & 0xFFFF;
            int ofh = c >>> 16;
            c = (z[0] & 0xFFFF) + ofl;
            v = (c >> 16) + (z[0] >>> 16) + ofh;
            z[0] = c & 0xFFFF | v << 16;
            c = v >> 16;
            v = ((c += (z[1] & 0xFFFF) - ofl) >> 16) + (z[1] >>> 16) - ofh;
            z[1] = c & 0xFFFF | v << 16;
            c = v >> 16;
            v = ((c += z[2] & 0xFFFF) >> 16) + (z[2] >>> 16);
            z[2] = c & 0xFFFF | v << 16;
            c = v >> 16;
            v = ((c += (z[3] & 0xFFFF) + ofl) >> 16) + (z[3] >>> 16) + ofh;
            z[3] = c & 0xFFFF | v << 16;
            c = v >> 16;
            v = ((c += (z[4] & 0xFFFF) + ofl) >> 16) + (z[4] >>> 16) + ofh;
            z[4] = c & 0xFFFF | v << 16;
            c = v >> 16;
            for (int i = 5; i != 12; ++i) {
                v = ((c += z[i] & 0xFFFF) >> 16) + (z[i] >>> 16);
                z[i] = c & 0xFFFF | v << 16;
                c = v >> 16;
            }
        }
        while (c > 0) {
            c += this.decFieldPrime(z);
        }
        while (c < 0) {
            c += this.incFieldPrime(z);
        }
        if (P384ECC32.leq(this.field_prime, z)) {
            this.decFieldPrime(z);
        }
    }
}

