/*
 * Decompiled with CFR 0.152.
 */
package com.galois.ecc;

import com.galois.ecc.NIST64;
import com.galois.ecc.P384Constants;

class P384ECC64
extends NIST64 {
    P384ECC64() {
        super(12, P384Constants.field_prime, P384Constants.unit_vector, P384Constants.group_order, P384Constants.basePoint);
        this.init();
    }

    @Override
    protected int decFieldPrime(int[] x) {
        long c = 0L;
        x[0] = (int)(c += ((long)x[0] & 0xFFFFFFFFL) + 1L);
        c >>= 32;
        x[1] = (int)(c += ((long)x[1] & 0xFFFFFFFFL) + 0xFFFFFFFFL);
        c >>= 32;
        x[2] = (int)(c += ((long)x[2] & 0xFFFFFFFFL) + 0xFFFFFFFFL);
        c >>= 32;
        x[3] = (int)(c += (long)x[3] & 0xFFFFFFFFL);
        c >>= 32;
        x[4] = (int)(c += ((long)x[4] & 0xFFFFFFFFL) + 1L);
        c >>= 32;
        x[5] = (int)(c += (long)x[5] & 0xFFFFFFFFL);
        c >>= 32;
        x[6] = (int)(c += (long)x[6] & 0xFFFFFFFFL);
        c >>= 32;
        x[7] = (int)(c += (long)x[7] & 0xFFFFFFFFL);
        c >>= 32;
        x[8] = (int)(c += (long)x[8] & 0xFFFFFFFFL);
        c >>= 32;
        x[9] = (int)(c += (long)x[9] & 0xFFFFFFFFL);
        c >>= 32;
        x[10] = (int)(c += (long)x[10] & 0xFFFFFFFFL);
        c >>= 32;
        x[11] = (int)(c += (long)x[11] & 0xFFFFFFFFL);
        return -1 + (int)(c >>= 32);
    }

    @Override
    protected int incFieldPrime(int[] x) {
        long b = 0L;
        x[0] = (int)(b += ((long)x[0] & 0xFFFFFFFFL) - 1L);
        b >>= 32;
        x[1] = (int)(b += ((long)x[1] & 0xFFFFFFFFL) - 0xFFFFFFFFL);
        b >>= 32;
        x[2] = (int)(b += ((long)x[2] & 0xFFFFFFFFL) - 0xFFFFFFFFL);
        b >>= 32;
        x[3] = (int)(b += (long)x[3] & 0xFFFFFFFFL);
        b >>= 32;
        x[4] = (int)(b += ((long)x[4] & 0xFFFFFFFFL) - 1L);
        b >>= 32;
        x[5] = (int)(b += (long)x[5] & 0xFFFFFFFFL);
        b >>= 32;
        x[6] = (int)(b += (long)x[6] & 0xFFFFFFFFL);
        b >>= 32;
        x[7] = (int)(b += (long)x[7] & 0xFFFFFFFFL);
        b >>= 32;
        x[8] = (int)(b += (long)x[8] & 0xFFFFFFFFL);
        b >>= 32;
        x[9] = (int)(b += (long)x[9] & 0xFFFFFFFFL);
        b >>= 32;
        x[10] = (int)(b += (long)x[10] & 0xFFFFFFFFL);
        b >>= 32;
        x[11] = (int)(b += (long)x[11] & 0xFFFFFFFFL);
        return 1 + (int)(b >>= 32);
    }

    @Override
    public void field_red(int[] z, int[] a) {
        long a0 = (long)a[0] & 0xFFFFFFFFL;
        long a12 = (long)a[12] & 0xFFFFFFFFL;
        long a1 = (long)a[1] & 0xFFFFFFFFL;
        long a13 = (long)a[13] & 0xFFFFFFFFL;
        long a2 = (long)a[2] & 0xFFFFFFFFL;
        long a14 = (long)a[14] & 0xFFFFFFFFL;
        long a3 = (long)a[3] & 0xFFFFFFFFL;
        long a15 = (long)a[15] & 0xFFFFFFFFL;
        long a4 = (long)a[4] & 0xFFFFFFFFL;
        long a16 = (long)a[16] & 0xFFFFFFFFL;
        long a5 = (long)a[5] & 0xFFFFFFFFL;
        long a17 = (long)a[17] & 0xFFFFFFFFL;
        long a6 = (long)a[6] & 0xFFFFFFFFL;
        long a18 = (long)a[18] & 0xFFFFFFFFL;
        long a7 = (long)a[7] & 0xFFFFFFFFL;
        long a19 = (long)a[19] & 0xFFFFFFFFL;
        long a8 = (long)a[8] & 0xFFFFFFFFL;
        long a20 = (long)a[20] & 0xFFFFFFFFL;
        long a9 = (long)a[9] & 0xFFFFFFFFL;
        long a21 = (long)a[21] & 0xFFFFFFFFL;
        long a10 = (long)a[10] & 0xFFFFFFFFL;
        long a22 = (long)a[22] & 0xFFFFFFFFL;
        long a11 = (long)a[11] & 0xFFFFFFFFL;
        long a23 = (long)a[23] & 0xFFFFFFFFL;
        long d = a0 + a12 + a21 + a20 - a23;
        z[0] = (int)d;
        d >>= 32;
        d = d + a1 + a13 + a22 + a23 - a12 - a20;
        z[1] = (int)d;
        d >>= 32;
        d = d + a2 + a14 + a23 - a13 - a21;
        z[2] = (int)d;
        d >>= 32;
        d = d + a3 + a15 + a12 + a20 + a21 - a14 - a22 - a23;
        z[3] = (int)d;
        d >>= 32;
        d = d + a4 + (a21 << 1) + a16 + a13 + a12 + a20 + a22 - a15 - (a23 << 1);
        z[4] = (int)d;
        d >>= 32;
        d = d + a5 + (a22 << 1) + a17 + a14 + a13 + a21 + a23 - a16;
        z[5] = (int)d;
        d >>= 32;
        d = d + a6 + (a23 << 1) + a18 + a15 + a14 + a22 - a17;
        z[6] = (int)d;
        d >>= 32;
        d = d + a7 + a19 + a16 + a15 + a23 - a18;
        z[7] = (int)d;
        d >>= 32;
        d = d + a8 + a20 + a17 + a16 - a19;
        z[8] = (int)d;
        d >>= 32;
        d = d + a9 + a21 + a18 + a17 - a20;
        z[9] = (int)d;
        d >>= 32;
        d = d + a10 + a22 + a19 + a18 - a21;
        z[10] = (int)d;
        d >>= 32;
        d = d + a11 + a23 + a20 + a19 - a22;
        z[11] = (int)d;
        d >>= 32;
        if ((d = (long)((int)d)) < 0L) {
            this.incFieldPrime(z);
            return;
        }
        if (d > 0L) {
            long of = d;
            d = ((long)z[0] & 0xFFFFFFFFL) + of;
            z[0] = (int)d;
            d >>= 32;
            d = d + ((long)z[1] & 0xFFFFFFFFL) - of;
            z[1] = (int)d;
            d >>= 32;
            z[2] = (int)(d += (long)z[2] & 0xFFFFFFFFL);
            d >>= 32;
            d = d + ((long)z[3] & 0xFFFFFFFFL) + of;
            z[3] = (int)d;
            d >>= 32;
            d = d + ((long)z[4] & 0xFFFFFFFFL) + of;
            z[4] = (int)d;
            d >>= 32;
            z[5] = (int)(d += (long)z[5] & 0xFFFFFFFFL);
            d >>= 32;
            z[6] = (int)(d += (long)z[6] & 0xFFFFFFFFL);
            d >>= 32;
            z[7] = (int)(d += (long)z[7] & 0xFFFFFFFFL);
            d >>= 32;
            z[8] = (int)(d += (long)z[8] & 0xFFFFFFFFL);
            d >>= 32;
            z[9] = (int)(d += (long)z[9] & 0xFFFFFFFFL);
            d >>= 32;
            z[10] = (int)(d += (long)z[10] & 0xFFFFFFFFL);
            d >>= 32;
            z[11] = (int)(d += (long)z[11] & 0xFFFFFFFFL);
            d >>= 32;
        }
        if (d > 0L || P384ECC64.leq(this.field_prime, z)) {
            this.decFieldPrime(z);
        }
    }

    @Override
    public int field_red_aux(int[] z, int[] a) {
        long a0 = (long)a[0] & 0xFFFFFFFFL;
        long a12 = (long)a[12] & 0xFFFFFFFFL;
        long a1 = (long)a[1] & 0xFFFFFFFFL;
        long a13 = (long)a[13] & 0xFFFFFFFFL;
        long a2 = (long)a[2] & 0xFFFFFFFFL;
        long a14 = (long)a[14] & 0xFFFFFFFFL;
        long a3 = (long)a[3] & 0xFFFFFFFFL;
        long a15 = (long)a[15] & 0xFFFFFFFFL;
        long a4 = (long)a[4] & 0xFFFFFFFFL;
        long a16 = (long)a[16] & 0xFFFFFFFFL;
        long a5 = (long)a[5] & 0xFFFFFFFFL;
        long a17 = (long)a[17] & 0xFFFFFFFFL;
        long a6 = (long)a[6] & 0xFFFFFFFFL;
        long a18 = (long)a[18] & 0xFFFFFFFFL;
        long a7 = (long)a[7] & 0xFFFFFFFFL;
        long a19 = (long)a[19] & 0xFFFFFFFFL;
        long a8 = (long)a[8] & 0xFFFFFFFFL;
        long a20 = (long)a[20] & 0xFFFFFFFFL;
        long a9 = (long)a[9] & 0xFFFFFFFFL;
        long a21 = (long)a[21] & 0xFFFFFFFFL;
        long a10 = (long)a[10] & 0xFFFFFFFFL;
        long a22 = (long)a[22] & 0xFFFFFFFFL;
        long a11 = (long)a[11] & 0xFFFFFFFFL;
        long a23 = (long)a[23] & 0xFFFFFFFFL;
        long d = a0 + a12 + a21 + a20 - a23;
        z[0] = (int)d;
        d >>= 32;
        d = d + a1 + a13 + a22 + a23 - a12 - a20;
        z[1] = (int)d;
        d >>= 32;
        d = d + a2 + a14 + a23 - a13 - a21;
        z[2] = (int)d;
        d >>= 32;
        d = d + a3 + a15 + a12 + a20 + a21 - a14 - a22 - a23;
        z[3] = (int)d;
        d >>= 32;
        d = d + a4 + (a21 << 1) + a16 + a13 + a12 + a20 + a22 - a15 - (a23 << 1);
        z[4] = (int)d;
        d >>= 32;
        d = d + a5 + (a22 << 1) + a17 + a14 + a13 + a21 + a23 - a16;
        z[5] = (int)d;
        d >>= 32;
        d = d + a6 + (a23 << 1) + a18 + a15 + a14 + a22 - a17;
        z[6] = (int)d;
        d >>= 32;
        d = d + a7 + a19 + a16 + a15 + a23 - a18;
        z[7] = (int)d;
        d >>= 32;
        d = d + a8 + a20 + a17 + a16 - a19;
        z[8] = (int)d;
        d >>= 32;
        d = d + a9 + a21 + a18 + a17 - a20;
        z[9] = (int)d;
        d >>= 32;
        d = d + a10 + a22 + a19 + a18 - a21;
        z[10] = (int)d;
        d >>= 32;
        d = d + a11 + a23 + a20 + a19 - a22;
        z[11] = (int)d;
        return (int)(d >>= 32);
    }
}

